/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.google.common.collect.Sets;
import com.scouter.oceansdelight.datagen.BlockTagsGenerator;
import com.scouter.oceansdelight.datagen.BlockstateGenerator;
import com.scouter.oceansdelight.datagen.ItemModelGenerator;
import com.scouter.oceansdelight.datagen.ItemTagsGenerator;
import com.scouter.oceansdelight.datagen.LanguageGenerator;
import com.scouter.oceansdelight.datagen.RecipeGenerator;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="oceansdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
        if (evt.includeClient()) {
            DataGenerators.registerClientProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        generator.m_123914_((DataProvider)new BlockTagsGenerator(generator, helper));
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        BlockTagsGenerator blockTags = new BlockTagsGenerator(generator, helper);
        HashSet set = Sets.newHashSet();
        Consumer<BlockStateGenerator> consumer = set::add;
        generator.m_123914_((DataProvider)new BlockstateGenerator(generator, helper));
        generator.m_123914_((DataProvider)new LanguageGenerator(generator));
        generator.m_123914_((DataProvider)new RecipeGenerator(generator));
        generator.m_123914_((DataProvider)new ItemTagsGenerator(generator, blockTags, helper));
        generator.m_123914_((DataProvider)new ItemModelGenerator(generator, helper));
    }
}

